-- Stugna-P by Currenthill

GT = {};
GT_t.ws = 0;
set_recursive_metatable(GT, GT_t.generic_human);
set_recursive_metatable(GT.chassis, GT_t.CH_t.HUMAN);
set_recursive_metatable(GT.armour_scheme, GT_t.unarmed_armour_scheme);

GT.visual.shape = "Stugna-P";
GT.visual.shape_dstr = "Stugna-P-dest";

GT.toggle_alarm_state_interval = 1.0;

GT.mobile = false;

GT.AddPropVehicle = {
			{ id = "Camouflage cover" , control = 'checkbox', label = _('Camouflage cover'), defValue = false, arg=250, boolean_inverted = false} -- boolean_inverted = true by default: element present - argVal=0, absent - argVal=1
		}

GT.sensor = {};
set_recursive_metatable(GT.sensor, GT_t.SN_visual);
GT.sensor.max_range_finding_target = 5500;
GT.sensor.min_range_finding_target = 0;
GT.sensor.max_alt_finding_target = 500;
GT.sensor.height = 10.0;

GT.WS = {};
GT.WS.maxTargetDetectionRange = 5500;
GT.WS.fire_on_march = false;

-- ================================== Stugna-P  =======================================================

local ws = GT_t.inc_ws();
GT.WS[ws] = {};
GT.WS[ws].pos = {0,1,0};
GT.WS[ws].angles = {
					{math.rad(180), math.rad(-180), math.rad(-45), math.rad(45)},
					};
GT.WS[ws].drawArgument1 = 0;
GT.WS[ws].drawArgument2 = 1;
GT.WS[ws].laser = true;
GT.WS[ws].omegaY = 1.5;
GT.WS[ws].omegaZ = 1.5;
GT.WS[ws].pidY = {p=40,i=1.0,d=7, inn = 5};
GT.WS[ws].pidZ = {p=40,i=1.0,d=7, inn = 5};	
GT.WS[ws].pointer = 'POINT_SIGHT_01';
GT.WS[ws].cockpit = { "BMP-3/BMP-3_gunner", {0.0, 0.0, 0.0 }, };

-- ================================== RK-2M-K launcher ===============================================

__LN = add_launcher(GT.WS[ws], GT_t.LN_t.Stugna_P_RK2MK)
__LN.BR[1] = {connector_name = 'POINT_MISSILE_01', drawArgument = 101}
__LN.radialDisperse = 0.0;
__LN.dispertionReductionFactor = 0.999;
__LN.missileControlInterval = 0.01;
__LN.inclination_correction_upper_limit = math.rad(90);		
__LN.inclination_correction_bias = math.rad(1.1);
__LN.sightMasterMode = 1;
__LN.sightIndicationMode = 4;

-- ====================================================================================================

GT.Name = "CH_Stugna_P";
GT.DisplayName = _("[CH] Stugna-P ATGM");
GT.DisplayNameShort = _('Stugna-P ATGM');
GT.Rate = 5;

GT.Sensors = {
	Mount_WS_ID = 1,
    OPTIC = {
        "TKN-3B day",
        "TKN-3B night",
    },
	noVisualDetectorInAlarmedState = false		
}

GT.Transportable = {
		size = 200
	};

GT.EPLRS = true

GT.DetectionRange = 5500;
GT.ThreatRange = 5500;
GT.mapclasskey = "P0091000201";
GT.attribute = {wsType_Ground,wsType_Tank,wsType_Gun,wsType_GenericInfantry,
				"Infantry",
				"ATGM",
				};
GT.category = "Infantry";

GT.Countries = {"Ukraine"}
